<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\AnalyticsData;

class Status extends \Google\Site_Kit_Dependencies\Google\Collection
{
    protected $collection_key = 'details';
    /**
     * @var int
     */
    public $code;
    /**
     * @var array[]
     */
    public $details;
    /**
     * @var string
     */
    public $message;
    /**
     * @param int
     */
    public function setCode($code)
    {
        $this->code = $code;
    }
    /**
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * @param array[]
     */
    public function setDetails($details)
    {
        $this->details = $details;
    }
    /**
     * @return array[]
     */
    public function getDetails()
    {
        return $this->details;
    }
    /**
     * @param string
     */
    public function setMessage($message)
    {
        $this->message = $message;
    }
    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\Status::class, 'Google\\Site_Kit_Dependencies\\Google_Service_AnalyticsData_Status');
